//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "OtherFunctions.h"
#include "Sion\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl]
#include "TreeFunctions.h"
#include "Sion/Functions.h"

void SetTreeGroup(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, int Icon, HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertGroup(Label,Icon, Parent); 
	hCtrl.SetItemInfo(hItem, Info ? Info : BLANK_INFO);
}

void SetTreeEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertItem(Label, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, Parent);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertItem(Label, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, Parent);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CNumTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void DDX_TreeEditE0(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, int& nValue)
{
	if (!pDX->m_bSaveAndValidate)
		if(nValue == 0){
			hCtrl->SetEditText(hItem, _T(""));
			return;
		}

	DDX_TreeEdit(pDX, nIDC, hItem, nValue);
}

void DDX_TreeEditE0f(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, float& nValue)
{
	if (!pDX->m_bSaveAndValidate)
		if(nValue == 0){
			hCtrl->SetEditText(hItem, _T(""));
			return;
		}

	DDX_TreeEdit(pDX, nIDC, hItem, nValue);
}

BOOL CheckTreeEditLimit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, int Min, int Def, int Max){
	CString strBuffer = hCtrl.GetEditText(hItem);
	if(!strBuffer.IsEmpty()){
		int iOldBuffer = _tstol(strBuffer);
		int iBuffer = Str2Int(strBuffer,Min,Def,Max);
		if(iBuffer != iOldBuffer){
			hCtrl.SetEditText(hItem,Int2Str(iBuffer));
			return TRUE;
		}
	}
	return FALSE;
}

BOOL CheckTreeEditLimitF(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, float Min, float Def, float Max){
	CString strBuffer = hCtrl.GetEditText(hItem);
	if(!strBuffer.IsEmpty()){
		float fOldBuffer = (float)_tstof(strBuffer);
		float fBuffer = Str2FloatNum(strBuffer,Min,Def,Max);
		if(fBuffer != fOldBuffer){
			hCtrl.SetEditText(hItem,FloatNum2Str(fBuffer));
			return TRUE;
		}
	}
	return FALSE;
}

void SetTreeCheckEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL TreeState, BOOL Value){
	hItem = hCtrl.InsertCheckBox(Label,Parent,Value,TreeState?1:0);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeCheckNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL TreeState, BOOL Value){
	hItem = hCtrl.InsertCheckBox(Label,Parent,Value,TreeState?1:0);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CNumTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeRadioNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL UnSetable, BOOL Value){
	hItem = hCtrl.InsertRadioButton(Label, Parent, Value, TVI_LAST, NULL, NULL, UnSetable);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CNumTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}


void SetTreeCheck(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL TreeState, BOOL Value){
	hItem = hCtrl.InsertCheckBox(Label,Parent,Value,TreeState?1:0);
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeRadio(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent,  LPCTSTR Info, BOOL UnSetable, BOOL Value){
	hItem = hCtrl.InsertRadioButton(Label, Parent, Value, TVI_LAST, NULL, NULL, UnSetable);
	hCtrl.SetItemInfo(hItem,Info);
}

/*void SetTreeCheckSpinNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, int Min, int Max, BOOL TreeState, BOOL Value){
	hItem = hCtrl.InsertCheckBox(Label,Parent,Value,TreeState?1:0);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CNumTreeOptionsEdit),RUNTIME_CLASS(CTreeOptionsSpinCtrl),((((DWORD)Min) << 16) + (DWORD)Max));
	hCtrl.SetItemInfo(hItem,Info);
}*/

void SetTreePriority(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertItem(Label, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, Parent);
	hCtrl.AddComboBox(hItem,RUNTIME_CLASS(CPriority));
	//hCtrl.SetItemSize(hItem,15);
	hCtrl.SetItemInfo(hItem,Info);
}

void DDX_PriorityT(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/, HTREEITEM hItem, int& nValue)
{
	CString sText;
	if (pDX->m_bSaveAndValidate){
		sText = hCtrl->GetComboText(hItem);
		if(sText == GetResString(IDS_X_PRIO_HIGH))
			nValue = THREAD_PRIORITY_HIGHEST;
		else if(sText == GetResString(IDS_X_PRIO_ABOVE))
			nValue = THREAD_PRIORITY_ABOVE_NORMAL;
		else if(sText == GetResString(IDS_X_PRIO_BELOW))
			nValue = THREAD_PRIORITY_BELOW_NORMAL;
		else if(sText == GetResString(IDS_X_PRIO_LOW))
			nValue = THREAD_PRIORITY_LOWEST;
		else if(sText == GetResString(IDS_X_PRIO_NORMAL))
			nValue = THREAD_PRIORITY_NORMAL;
	}else{
		switch(nValue){
			case THREAD_PRIORITY_HIGHEST:
				sText = GetResString(IDS_X_PRIO_HIGH); break;
			case THREAD_PRIORITY_ABOVE_NORMAL:
				sText = GetResString(IDS_X_PRIO_ABOVE); break;
			case THREAD_PRIORITY_BELOW_NORMAL:
				sText = GetResString(IDS_X_PRIO_BELOW); break;
			case THREAD_PRIORITY_LOWEST:
				sText = GetResString(IDS_X_PRIO_LOW); break;
			case THREAD_PRIORITY_NORMAL:
			default:
				sText = GetResString(IDS_X_PRIO_NORMAL);
		}
		hCtrl->SetComboText(hItem, sText);
	}
}

void DDX_PriorityC(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/, HTREEITEM hItem, DWORD& nValue)
{
	CString sText;
	if (pDX->m_bSaveAndValidate){
		sText = hCtrl->GetComboText(hItem);
		if(sText == GetResString(IDS_X_PRIO_HIGH))
			nValue = HIGH_PRIORITY_CLASS;
		else if(sText == GetResString(IDS_X_PRIO_ABOVE))
			nValue = ABOVE_NORMAL_PRIORITY_CLASS;
		else if(sText == GetResString(IDS_X_PRIO_BELOW))
			nValue = BELOW_NORMAL_PRIORITY_CLASS;
		else if(sText == GetResString(IDS_X_PRIO_LOW))
			nValue = IDLE_PRIORITY_CLASS;
		else if(sText == GetResString(IDS_X_PRIO_NORMAL))
			nValue = NORMAL_PRIORITY_CLASS;
	}else{
		switch(nValue){
			case HIGH_PRIORITY_CLASS:
				sText = GetResString(IDS_X_PRIO_HIGH); break;
			case ABOVE_NORMAL_PRIORITY_CLASS:
				sText = GetResString(IDS_X_PRIO_ABOVE); break;
			case BELOW_NORMAL_PRIORITY_CLASS:
				sText = GetResString(IDS_X_PRIO_BELOW); break;
			case IDLE_PRIORITY_CLASS:
				sText = GetResString(IDS_X_PRIO_LOW); break;
			case NORMAL_PRIORITY_CLASS:
			default:
				sText = GetResString(IDS_X_PRIO_NORMAL);
		}
		hCtrl->SetComboText(hItem, sText);
	}
}

IMPLEMENT_DYNCREATE(CPriority, CTreeOptionsCombo)

CPriority::CPriority()
{
}

CPriority::~CPriority()
{
}

BEGIN_MESSAGE_MAP(CPriority, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CPriority)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CPriority::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	AddString(GetResString(IDS_X_PRIO_HIGH));
	AddString(GetResString(IDS_X_PRIO_ABOVE));
	AddString(GetResString(IDS_X_PRIO_NORMAL));
	AddString(GetResString(IDS_X_PRIO_BELOW));
	AddString(GetResString(IDS_X_PRIO_LOW));

	return 0;
}

DWORD CPriority::GetWindowStyle()
{
	return WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWN;
}
